/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskArchitecture
extends PeerCompatibleTask {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1050", false);
    private List<String> m_arch;

    public TaskArchitecture(List<String> archs) {
        this.m_arch = archs;
    }

    @Override
    public boolean performTask() {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet archRsltSet = new ResultSet();
        globalExec.checkArchitecture(this.m_nodeList, this.m_arch, archRsltSet);
        this.m_resultSet.uploadResultSet(archRsltSet);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1000", false, (Object[])new String[]{CONSTRAINT_NAME}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.STATUS);
        Hashtable t = archRsltSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String avl;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                avl = (String)result.getResultInfoSet().firstElement();
                Trace.out((String)("Result.OPERATION_SUCCESSFUL:: available architecture=" + avl));
                ReportUtil.writeRecord(node, avl, VerificationUtil.strCollection2String(this.m_arch), ReportUtil.PASSED);
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(VerificationUtil.strCollection2String(this.m_arch));
                this.m_resultSet.getResult(node).setActualValue(avl);
                continue;
            }
            if (result.getStatus() == 3) {
                avl = (String)result.getResultInfoSet().firstElement();
                Trace.out((String)("Result.VERIFICATION_FAILED:: available architecture=" + avl));
                ReportUtil.writeRecord(node, avl, VerificationUtil.strCollection2String(this.m_arch), ReportUtil.FAILED);
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7535", true, (Object[])new String[]{node, VerificationUtil.strCollection2String(this.m_arch), avl}), s_msgBundle, "7535");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(VerificationUtil.strCollection2String(this.m_arch));
                this.m_resultSet.getResult(node).setActualValue(avl);
                continue;
            }
            Trace.out((String)("FAILED:: result.getStatus()=" + result.getStatus()));
            ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, VerificationUtil.strCollection2String(this.m_arch), ReportUtil.FAILED);
            errDesc = new ErrorDescription(s_msgBundle.getMessage("7536", true, (Object[])new String[]{node}), s_msgBundle, "7536");
            this.m_resultSet.getResult(node).addErrorDescription(errDesc);
        }
        if (this.m_resultSet.allSuccess()) {
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0312", false, (Object[])new String[]{VerificationUtil.strCollection2String(this.m_arch)}));
            ReportUtil.printResult(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
            return true;
        }
        this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0313", false, (Object[])new String[]{VerificationUtil.strCollection2String(this.m_arch), VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
        ReportUtil.printResult(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4403", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4453", false);
    }

    @Override
    public ResultSet performPeer() throws VerificationException {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet archRsltSet = new ResultSet();
        globalExec.checkArchitecture(this.m_nodeList, new ArrayList<String>(), archRsltSet);
        return archRsltSet;
    }

    @Override
    public String getElementDisplayName() {
        return s_msgBundle.getMessage("1050", false);
    }
}

